jQuery(function($){

var USMALOS = window.USMALOS || {};

/* ==================================================
   Mobile Navigation
================================================== */
var mobileMenuClone = $('#menu').clone().attr('id', 'navigation-mobile');

USMALOS.mobileNav = function(){
	var windowWidth = $(window).width();
	
	if( windowWidth <= 979 ) {
		if( $('#mobile-nav').length > 0 ) {
			mobileMenuClone.insertAfter('#menu');
			$('#navigation-mobile #menu-nav').attr('id', 'menu-nav-mobile');
		}
	} else {
		$('#navigation-mobile').css('display', 'none');
		if ($('#mobile-nav').hasClass('open')) {
			$('#mobile-nav').removeClass('open');	
		}
	}
}

USMALOS.listenerMenu = function(){
	$('#mobile-nav').on('click', function(e){
		$(this).toggleClass('open');
		
		if ($('#mobile-nav').hasClass('open')) {
			$('#navigation-mobile').slideDown(500, 'easeOutExpo');
		} else {
			$('#navigation-mobile').slideUp(500, 'easeOutExpo');
		}
		e.preventDefault();
	});
	
	$('#menu-nav-mobile a').on('click', function(){
		$('#mobile-nav').removeClass('open');
		$('#navigation-mobile').slideUp(350, 'easeOutExpo');
	});
}


/* ==================================================
   Slider Options
================================================== */

USMALOS.slider = function(){
	$.supersized({
		// Functionality
		slideshow               :   1,			// Slideshow on/off
		autoplay				:	1,			// Slideshow starts playing automatically
		start_slide             :   1,			// Start slide (0 is random)
		stop_loop				:	0,			// Pauses slideshow on last slide
		random					: 	0,			// Randomize slide order (Ignores start slide)
		slide_interval          :   8000,		// Length between transitions
		transition              :   1, 			// 0-None, 1-Fade, 2-Slide Top, 3-Slide Right, 4-Slide Bottom, 5-Slide Left, 6-Carousel Right, 7-Carousel Left
		transition_speed		:	700,		// Speed of transition
		new_window				:	0,			// Image links open in new window/tab
		pause_hover             :   0,			// Pause slideshow on hover
		keyboard_nav            :   1,			// Keyboard navigation on/off
		performance				:	1,			// 0-Normal, 1-Hybrid speed/quality, 2-Optimizes image quality, 3-Optimizes transition speed // (Only works for Firefox/IE, not Webkit)
		image_protect			:	1,			// Disables image dragging and right click with Javascript
												   
		// Size & Position						   
		min_width		        :   0,			// Min width allowed (in pixels)
		min_height		        :   0,			// Min height allowed (in pixels)
		vertical_center         :   0,			// Vertically center background
		horizontal_center       :   1,			// Horizontally center background
		fit_always				:	0,			// Image will never exceed browser width or height (Ignores min. dimensions)
		fit_portrait         	:   1,			// Portrait images will not exceed browser height
		fit_landscape			:   0,			// Landscape images will not exceed browser width
												   
		// Components							
		slide_links				:	'blank',	// Individual links for each slide (Options: false, 'num', 'name', 'blank')
		thumb_links				:	0,			// Individual thumb links for each slide
		thumbnail_navigation    :   0,			// Thumbnail navigation
		slides 					:  	[			// Slideshow Images
											{image : '../_include/img/slider-images/enimage01.jpg', title : '<div class="slide-link"><a href="../en/about-the-program-of-earth-rescue-usmalos">&nbsp;</a></div><br><div class="slide-content"> | <a href="../en/about-the-mother-of-the-world.html" class="external">ABOUT THE MOTHER OF THE WORLD</a> | <a href="../en/about-the-program-of-earth-rescue-usmalos.html" class="external">ABOUT THE PROGRAM</a> | <a href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html" class="external">PROPHECIES</a> | <a href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html" class="external">PROTECTION FROM CHIPIZATION</a></div>', thumb : '', url : ''},
											{image : '../_include/img/slider-images/enimage02.jpg', title : '<div class="slide-link"><a class="button button-mini" href="../en/about-the-program-of-earth-rescue-usmalos.html">go to section</a></a></div> | <a href="../en/about-the-mother-of-the-world.html" class="external">ABOUT THE MOTHER OF THE WORLD</a> | <a href="../en/about-the-program-of-earth-rescue-usmalos.html" class="external">ABOUT THE PROGRAM</a> | <a href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html" class="external">PROPHECIES</a> | <a href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html" class="external">PROTECTION FROM CHIPIZATION</a></div>', thumb : '', url : ''},
											{image : '../_include/img/slider-images/enimage03.jpg', title : '<div class="slide-link"><a class="button button-mini" href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html">go to section</a></a></div> | <a href="../en/about-the-mother-of-the-world.html" class="external">ABOUT THE MOTHER OF THE WORLD</a> | <a href="../en/about-the-program-of-earth-rescue-usmalos.html" class="external">ABOUT THE PROGRAM</a> | <a href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html" class="external">PROPHECIES</a> | <a href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html" class="external">PROTECTION FROM CHIPIZATION</a></div>', thumb : '', url : ''},
											{image : '../_include/img/slider-images/enimage04.jpg', title : '<div class="slide-link"><a class="button button-mini" href="../en/spiritual-cosmic-idea-of-the-mother-of-the-world.html">go to section</a></a></div> | <a href="../en/about-the-mother-of-the-world.html" class="external">ABOUT THE MOTHER OF THE WORLD</a> | <a href="../en/about-the-program-of-earth-rescue-usmalos.html" class="external">ABOUT THE PROGRAM</a> | <a href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html" class="external">PROPHECIES</a> | <a href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html" class="external">PROTECTION FROM CHIPIZATION</a></div>', thumb : '', url : ''},
											{image : '../_include/img/slider-images/enimage05.jpg', title : '<div class="slide-link"><a class="button button-mini" href="../en/histary-of-the-slavic-movement-of-the-90s-the-great-white-brotherhood-usmalos.html">go to section</a></a></div> | <a href="../en/about-the-mother-of-the-world.html" class="external">ABOUT THE MOTHER OF THE WORLD</a> | <a href="../en/about-the-program-of-earth-rescue-usmalos.html" class="external">ABOUT THE PROGRAM</a> | <a href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html" class="external">PROPHECIES</a> | <a href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html" class="external">PROTECTION FROM CHIPIZATION</a></div>', thumb : '', url : ''},
											{image : '../_include/img/slider-images/enimage06.jpg', title : '<div class="slide-link"><a class="button button-mini" href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html">go to section</a></a></div> | <a href="../en/about-the-mother-of-the-world.html" class="external">ABOUT THE MOTHER OF THE WORLD</a> | <a href="../en/about-the-program-of-earth-rescue-usmalos.html" class="external">ABOUT THE PROGRAM</a> | <a href="../en/prophecies-about-the-phenomenon-of-the-mother-of-the-world/index.html" class="external">PROPHECIES</a> | <a href="../en/protection-from-chipization-is-the-light-cover-of-mother-of-the-world-maria-devi-christos/index.html" class="external">PROTECTION FROM CHIPIZATION</a></div>', thumb : '', url : ''}
									],
									
		// Theme Options			   
		progress_bar			:	1,			// Timer for each slide							
		mouse_scrub				:	1
		
	});

}


/* ==================================================
   Navigation Fix
================================================== */

USMALOS.nav = function(){
	$('.sticky-nav').waypoint('sticky');
}


/* ==================================================
   Filter Works
================================================== */

USMALOS.filter = function (){
	if($('#projects').length > 0){		
		var $container = $('#projects');
		
		$container.imagesLoaded(function() {
			$container.isotope({
			  // options
			  animationEngine: 'best-available',
			  itemSelector : '.item-thumbs',
			  layoutMode : 'fitRows'
			});
		});
	
		
		// filter items when filter link is clicked
		var $optionSets = $('#options .option-set'),
			$optionLinks = $optionSets.find('a');
	
		  $optionLinks.click(function(){
			var $this = $(this);
			// don't proceed if already selected
			if ( $this.hasClass('selected') ) {
			  return false;
			}
			var $optionSet = $this.parents('.option-set');
			$optionSet.find('.selected').removeClass('selected');
			$this.addClass('selected');
	  
			// make option object dynamically, i.e. { filter: '.my-filter-class' }
			var options = {},
				key = $optionSet.attr('data-option-key'),
				value = $this.attr('data-option-value');
			// parse 'false' as false boolean
			value = value === 'false' ? false : value;
			options[ key ] = value;
			if ( key === 'layoutMode' && typeof changeLayoutMode === 'function' ) {
			  // changes in layout modes need extra logic
			  changeLayoutMode( $this, options )
			} else {
			  // otherwise, apply new options
			  $container.isotope( options );
			}
			
			return false;
		});
	}
}


/* ==================================================
   FancyBox
================================================== */

USMALOS.fancyBox = function(){
	if($('.fancybox').length > 0 || $('.fancybox-media').length > 0 || $('.fancybox-various').length > 0){
		
		$(".fancybox").fancybox({				
				padding : 0,
				beforeShow: function () {
					this.title = $(this.element).attr('title');
					this.title = '<h4>' + this.title + '</h4>' + '<p>' + $(this.element).parent().find('img').attr('alt') + '</p>';
				},
				helpers : {
					title : { type: 'inside' },
				}
			});
			
		$('.fancybox-media').fancybox({
			openEffect  : 'none',
			closeEffect : 'none',
			helpers : {
				media : {}
			}
		});
	}
}


/* ==================================================
   Contact Form
================================================== */

USMALOS.contactForm = function(){
	$("#contact-submit").on('click',function() {
		$contact_form = $('#contact-form');
		
		var fields = $contact_form.serialize();
		
		$.ajax({
			type: "POST",
			url: "_include/php/contact.php",
			data: fields,
			dataType: 'json',
			success: function(response) {
				
				if(response.status){
					$('#contact-form input').val('');
					$('#contact-form textarea').val('');
				}
				
				$('#response').empty().html(response.html);
			}
		});
		return false;
	});
}



/* ==================================================
   Menu Highlight
================================================== */

USMALOS.menu = function(){
	$('#menu-nav, #menu-nav-mobile').onePageNav({
		currentClass: 'current',
    	changeHash: false,
    	scrollSpeed: 750,
    	scrollOffset: 30,
    	scrollThreshold: 0.5,
		easing: 'easeOutExpo',
		filter: ':not(.external)'
	});
}

/* ==================================================
   Next Section
================================================== */

USMALOS.goSection = function(){
	$('#nextsection').on('click', function(){
		$target = $($(this).attr('href')).offset().top-30;
		
		$('body, html').animate({scrollTop : $target}, 750, 'easeOutExpo');
		return false;
	});
}

/* ==================================================
   GoUp
================================================== */

USMALOS.goUp = function(){
	$('#goUp').on('click', function(){
		$target = $($(this).attr('href')).offset().top-30;
		
		$('body, html').animate({scrollTop : $target}, 750, 'easeOutExpo');
		return false;
	});
}


/* ==================================================
	Scroll to Top
================================================== */

USMALOS.scrollToTop = function(){
	var windowWidth = $(window).width(),
		didScroll = false;

	var $arrow = $('#back-to-top');

	$arrow.click(function(e) {
		$('body,html').animate({ scrollTop: "0" }, 750, 'easeOutExpo' );
		e.preventDefault();
	})

	$(window).scroll(function() {
		didScroll = true;
	});

	setInterval(function() {
		if( didScroll ) {
			didScroll = false;

			if( $(window).scrollTop() > 1000 ) {
				$arrow.css('display', 'block');
			} else {
				$arrow.css('display', 'none');
			}
		}
	}, 250);
}

/* ==================================================
   Thumbs / Social Effects
================================================== */

USMALOS.utils = function(){
	
	$('.item-thumbs').bind('touchstart', function(){
		$(".active").removeClass("active");
      	$(this).addClass('active');
    });
	
	$('.image-wrap').bind('touchstart', function(){
		$(".active").removeClass("active");
      	$(this).addClass('active');
    });
	
	$('#social ul li').bind('touchstart', function(){
		$(".active").removeClass("active");
      	$(this).addClass('active');
    });
	
}

/* ==================================================
   Accordion
================================================== */

USMALOS.accordion = function(){
	var accordion_trigger = $('.accordion-heading.accordionize');
	
	accordion_trigger.delegate('.accordion-toggle','click', function(event){
		if($(this).hasClass('active')){
			$(this).removeClass('active');
		   	$(this).addClass('inactive');
		}
		else{
		  	accordion_trigger.find('.active').addClass('inactive');          
		  	accordion_trigger.find('.active').removeClass('active');   
		  	$(this).removeClass('inactive');
		  	$(this).addClass('active');
	 	}
		event.preventDefault();
	});
}

/* ==================================================
   Toggle
================================================== */

USMALOS.toggle = function(){
	var accordion_trigger_toggle = $('.accordion-heading.togglize');
	
	accordion_trigger_toggle.delegate('.accordion-toggle','click', function(event){
		if($(this).hasClass('active')){
			$(this).removeClass('active');
		   	$(this).addClass('inactive');
		}
		else{
		  	$(this).removeClass('inactive');
		  	$(this).addClass('active');
	 	}
		event.preventDefault();
	});
}

/* ==================================================
   Tooltip
================================================== */

USMALOS.toolTip = function(){ 
    $('a[data-toggle=tooltip]').tooltip();
}


/* ==================================================
	Init
================================================== */

USMALOS.slider();

$(document).ready(function(){
	Modernizr.load([
	{
		test: Modernizr.placeholder,
		nope: '_include/js/placeholder.js', 
		complete : function() {
				if (!Modernizr.placeholder) {
						Placeholders.init({
						live: true,
						hideOnFocus: false,
						className: "yourClass",
						textColor: "#999"
						});    
				}
		}
	}
	]);
	
	// Preload the page with jPreLoader
	$('body').jpreLoader({
		splashID: "#jSplash",
		showSplash: true,
		showPercentage: true,
		autoClose: true,
		splashFunction: function() {
			$('#circle').delay(250).animate({'opacity' : 1}, 500, 'linear');
		}
	});
	
	USMALOS.nav();
	USMALOS.mobileNav();
	USMALOS.listenerMenu();
	USMALOS.menu();
	USMALOS.goSection();
	USMALOS.goUp();
	USMALOS.filter();
	USMALOS.fancyBox();
	USMALOS.contactForm();
	USMALOS.scrollToTop();
	USMALOS.utils();
	USMALOS.accordion();
	USMALOS.toggle();
	USMALOS.toolTip();
});

$(window).resize(function(){
	USMALOS.mobileNav();
});

});
